
//Normal Distribution
//OS:Windows 10
//Scilab 5.5.2

clear all;
clc;
close;


mprintf("In Normal Distribution: \n mu = Xbar \n sigma^2 = S^2 \n")

value = [99.79,100.26,100.23,99.55,99.96,99.56,100.41,100.27,99.62,99.90,100.17,99.98,100.02,99.65,100.06,100.33,99.83,100.47,99.82,99.85] 

V = gsort(value,'g','i')
V2 =[]
n =length(V)

for i=1:n
    V2($+1)=(V(i)**2)
end

Xbar = sum(V)/n
S2 = (sum(V2) - (n*(Xbar)**2))/(n-1)
S = sqrt(S2)

//Result
mprintf("\n   -----------------------------------------\n")
mprintf("     j\t\tvalue\tj\tvalue")
mprintf("\n   -----------------------------------------\n")
ul=n/2
for i=1:ul
    mprintf("\n     %d\t\t%.2f\t%d\t%.2f",i,V(i),(i+10),V(i+10))
end
mprintf("\n   -----------------------------------------\n")
mprintf("\n N=%d",n)
mprintf("\n mu = Xbar = Sum(V)/N = %f",Xbar)
mprintf("\nsigma^2 = (S^2) = (%f)^2 second^2",S)
